/* 
 * MTKNetwork:  A MTK plugin to monitor network usage.
 * Copyright (C) 2002-2005 Mike Piatek-Jimenez, Gaucho Software
 * You can view the complete license in the LICENSE file in the root
 * of the source tree.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

//
//  GSNetMiner.h
//

#import <Cocoa/Cocoa.h>
#import <GSFoundation/GSDataSet.h>

typedef struct io_stats {
    UInt64  bytes_delta;
    UInt64  bytes_prev;
    UInt64  bytes;
    UInt64  bsd_bytes_prev;
    UInt64  bsd_bytes;
}io_stats;

typedef struct network_interface_stats {
    char            if_name[32];
    struct io_stats if_in;
    struct io_stats if_out;
}network_interface_stats;

@interface GSNetMiner : NSObject {   
	@private
    int                     numSamples;
    
    io_stats                i_net, o_net;
    network_interface_stats *interfaceStats;
    int                     pppInterfaceNum;
    int                     numInterfaces;
    int                     sendBytes;
    int                     recvBytes;
    UInt64                  totalBytesSinceBoot;
    UInt64                  totalBytesSinceLoad;
    int                     mib[6];
    char                    *buf;
    int                     alloc;
	
	GSDataSet				*rxData;
	GSDataSet				*txData;
	GSDataSet				*totalData;
	
    int                     *rxValues;
    int                     *txValues;
    int                     *values;
	
    int                     old_clock;
	long long				lastTime;
    
    bool                    firstTimeStats;
    NSMutableArray          *networkInterfaces;
}

#pragma mark Data Update Methods
- (void) tick;
- (void) setCurrentBandwidth;
- (void) getInterfacesBandwidth;
- (void) setInterfaceBandwidth:(char *)interface_name inBytes:(UInt64)in_bytes outBytes:(UInt64)out_bytes;
- (void) setNetworkInterfaces:(char **)interfaces;

#pragma mark Information Retrieval
- (int) getSendBytes;
- (int) getRecvBytes;
- (int) getMaxValue;
- (NSArray *) networkInterfaces;

#pragma mark Class Configuration
- (void) setDataSize:(int)newNumSamples;
@end
